#include <bits/stdc++.h>
using namespace std;
using ll = long long;

struct Node {
    ll sval;      
    ll wsum;      
    ll origVal;   
    int prev;     
    int item;     
    Node(ll s=0, ll w=0, ll o=0, int p=-1, int it=-1)
        : sval(s), wsum(w), origVal(o), prev(p), item(it) {}
};

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int N;
    long long W;
    double eps_d;
    if(!(cin >> N >> W >> eps_d)) return 0;
    vector<ll> w(N+1), v(N+1);
    ll vmax = 0;
    for(int i=1;i<=N;i++){
        cin >> w[i] >> v[i];
        vmax = max(vmax, v[i]);
    }
    double eps = eps_d;
    if(eps <= 0) eps = 0.01;

    if(N == 0){
        cout << 0 << "\n\n";
        return 0;
    }
    if(vmax == 0){
        cout << 0 << "\n\n";
        return 0;
    }

    double Bd = (eps * (double)vmax) / (double)max(1, N);
    ll B = (ll)floor(Bd + 1e-12);
    if(B <= 0) B = 1; 

    vector<ll> vs(N+1);
    for(int i=1;i<=N;i++){
        vs[i] = v[i] / B; 
        if(vs[i] < 0) vs[i] = 0;
    }

    vector<Node> pool;
    pool.reserve(1000000);
    pool.emplace_back(0,0,0,-1,-1);
    vector<int> curr; curr.push_back(0);

    for(int i=1;i<=N;i++){
        vector<int> new_indices;
        new_indices.reserve(curr.size());
        for(int idx : curr){
            ll nw = pool[idx].wsum + w[i];
            if(nw > W) continue;
            ll ns = pool[idx].sval + vs[i];
            ll no = pool[idx].origVal + v[i];
            pool.emplace_back(ns, nw, no, idx, i);
            new_indices.push_back((int)pool.size() - 1);
        }
 
        vector<int> cand;
        cand.reserve(curr.size() + new_indices.size());
        for(int x : curr) cand.push_back(x);
        for(int x : new_indices) cand.push_back(x);

      
        sort(cand.begin(), cand.end(), [&](int a, int b){
            if(pool[a].sval != pool[b].sval) return pool[a].sval < pool[b].sval;
            return pool[a].wsum < pool[b].wsum;
        });

     
        vector<int> next;
        next.reserve(cand.size());
        ll best_w = LLONG_MAX;
        for(int idx : cand){
            if(pool[idx].wsum > W) continue;
            if(pool[idx].wsum < best_w){
                next.push_back(idx);
                best_w = pool[idx].wsum;
            }
        }
        curr.swap(next);

    }

    ll bestVal = 0;
    int bestIdx = 0;
    for(int idx : curr){
        if(pool[idx].wsum <= W && pool[idx].origVal > bestVal){
            bestVal = pool[idx].origVal;
            bestIdx = idx;
        }
    }

    vector<int> chosen;
    int cur = bestIdx;
    while(cur != 0 && cur != -1){
        int it = pool[cur].item;
        if(it != -1) chosen.push_back(it);
        cur = pool[cur].prev;
    }
    reverse(chosen.begin(), chosen.end());

    cout << (int)chosen.size() << "\n";
    if(!chosen.empty()){
        for(size_t i=0;i<chosen.size();++i){
            cout << chosen[i] << (i+1==chosen.size()?'\n':' ');
        }
    } else {
        cout << "\n";
    }
    return 0;
}